local bottomX = math.cos(-math.pi / 6)
local bottomY = math.sin(-math.pi / 6)
local unitArea = (2 * bottomX * (1 - bottomY)) / 2
local sizeRatio = math.sqrt(4 / unitArea)

TrianglePointStamp = function(canvas, x, y, radius, paint)
    local size = (radius or 2) * sizeRatio
    local path = Path.point{
        x = x,
        y = y + size,
    }:addLine{
        x = x + bottomX * size,
        y = y + bottomY * size,
    }:addLine{
        x = x - bottomX * size,
        y = y + bottomY * size,
    }:closeSubpath()
    canvas:setPaint(paint):fill(path)
end

return TrianglePointStamp
